<?php
# __      ______
# \ \ /\ / /_  /
#  \ V  V / / / 
#   \_/\_/ /___|
#    wz -- v0.2               
#
# F.P. Laussy -- fabrice.laussy@gmail.org
# http://laussy.org
#
# Bring the beauty of Walter Zorn's tooltips (http://goo.gl/YDg9x) to Mediawiki.
# See http://laussy.org/wiki/wz for details
# Mon Jun 13 21:21:08 CEST 2011
# Thu May  1 22:28:11 CEST 2014

$wgExtensionCredits['other'][] = array(
  'name' => 'wz',
  'version' => '0.2',
  'author' => '[http://laussy.org/wiki/fabrice F.P. Laussy]',
  'url' => 'http://laussy.org/wiki/wz',
  'description' => 'Power mediawiki with Walter Zorn tooltips'
);
 
if ( defined( 'MW_SUPPORTS_PARSERFIRSTCALLINIT' ) ) {
  $wgHooks['ParserFirstCallInit'][] = 'wfwz';
 }
 else {
   $wgExtensionFunctions[] = 'wfwz';
 }

function wfwz() {
  global $wgParser;
  $wgParser->setHook( 'wz', 'renderwztag' );
  return true;
}

function renderwztag( $input, $args, $parser, $frame ) {
  # escape quotes
  global $wgParser;
  $tiptext = preg_replace('/\'/',"\'",($parser->recursiveTagParse($args['tip'])));
  
#  $event = "style=\"text-decoration: none; border-bottom:1px dotted;\"";
  $event = "style=\"color: #246B47;\"";

  if (isset($args['tip']))
    $event .= "onmouseover=\"Tip('" .  $tiptext ."'"; #. "')\" onmouseout=\"UnTip()\" ";
  else
    $event .= "onmouseover=\"TagToTip('" . $parser->recursiveTagParse($args['tagtotip'] ). "'"; #"')\" onmouseout=\"UnTip()\" ";
 
  foreach( $args as $name => $value )
    if ($name != "tip" && $name != "tagtotip")
      $event .= ',' . strtoupper($name) . ',\'' . htmlspecialchars( $value ) . '\'';

  $event .= ")\" onmouseout=\"UnTip()\" ";

  $output = "<span ${event}>".$parser->recursiveTagParse($input)."</span>";
  return $output;
}