<?php
# __      ______
# \ \ /\ / /_  /
#  \ V  V / / / 
#   \_/\_/ /___|
#    wz -- v0.1               
#
# F.P. Laussy -- fabrice.laussy@gmail.org
# http://laussy.org
#
# Bring the beauty of Walter Zorn's tooltips (http://goo.gl/YDg9x) to Mediawiki.
# See http://laussy.org/wiki/wz for details
# Mon Jun 13 21:21:08 CEST 2011
 
$wgExtensionCredits['other'][] = array(
  'name' => 'wz',
  'version' => '0.1',
  'author' => '[http://laussy.org/wiki/fabrice F.P. Laussy]',
  'url' => 'http://laussy.org/wiki/wz',
  'description' => 'Power mediawiki with Walter Zorn tooltips'
);
 
if ( defined( 'MW_SUPPORTS_PARSERFIRSTCALLINIT' ) ) {
  $wgHooks['ParserFirstCallInit'][] = 'wfwz';
 }
 else {
   $wgExtensionFunctions[] = 'wfwz';
 }

function wfwz() {
  global $wgParser;
  $wgParser->setHook( 'wz', 'renderwztag' );
  return true;
}

function renderwztag( $input, $args, $parser, $frame ) {
# escape quotes
  $tiptext   = preg_replace('/\"/','\"',$args['tip']);
  $tiptext   = preg_replace('/\'/',"\'",$args['tip']);
 
  if (isset($args['tip']))
    $event = " onmouseover=\"Tip('" . $tiptext . "')\" onmouseout=\"UnTip()\"";
  else
    $event = " onmouseover=\"TagToTip('" . $args['tagtotip'] . "')\" onmouseout=\"UnTip()\"";

  $output = "<span ${event}>".$parser->recursiveTagParse($input)."</span>";

  return $output;
}